from enum import IntEnum


class StateIndex(IntEnum):
    """
    Index mapping for the state vector
    """

    X_POS = 0  # [m] The x position in global coordinates.
    Y_POS = 1  # [m] The y position in global coordinates.
    YAW = 2  # [rad] The yaw in global coordinates.
    X_VELOCITY = 3  # [m/s] The velocity along the longitudinal axis of the vehicles.
    Y_VELOCITY = 4  # [m/s] The velocity along the lateral axis of the vehicles.
    YAW_RATE = 5  # [m/s] The yaw rate.


class InputIndex(IntEnum):
    """
    Index mapping for the input vector
    """

    ACCEL = 0  # [m/s^2]   The acceleration along the longitudinal axis of the vehicles.
    STEERING_ANGLE = 1  # [rad]     The steering angle.
